//The Z6427 sets up an AP with these credentials:
#define STASSID "KeyesWifi_A"
#define STAPSK "KeyesWifi"
//at this server/port
const char* host = "192.168.2.1";
const uint16_t port = 8080;

const char* ssid = STASSID;
const char* password = STAPSK;

//for Pico:
#include <WiFi.h>
WiFiMulti multi;
WiFiClient client;
#define MAX_RELAYS 26
int n=0;  //count of WiFi Relay modules found
int idx[MAX_RELAYS];  //index of WiFi Relays in scan results
uint8_t bssid[6]; //for general use
uint8_t lastBSSID[6]; 
uint8_t nullBSSID[6]={0,0,0,0,0,0}; //for general use
uint8_t relayBSSID[MAX_RELAYS][6]; //for indexed controls
char relay=0;
char command=0;

void setup() {
  int cnt,i;
  Serial.begin(115200);
  while(!Serial && millis()<5000){}   //wait for serial with timeout
  WiFi.mode(WIFI_STA);
  Serial.println("Scanning");
  cnt = WiFi.scanNetworks();
  if (!cnt) {
    Serial.printf("No networks found\n");
    delay(5000);
    rp2040.reboot();
  } else {
    for(i=0;i<cnt;i++){
      //WiFi.SSID(i).toCharArray(buf,BUFSIZE);
      if(strcmp(ssid,WiFi.SSID(i))==0){
        idx[n]=i;
        n=n+1;
        idx[n]=-1;
      }
    }
    if(n==0){
      Serial.printf("No WiFi Relays found\n");
      delay(5000);
      rp2040.reboot();
    }
    Serial.printf("Found %d WiFi Relays.\r\n", n);
    Serial.printf("  %32s %5s %17s %2s %4s\r\n", "SSID", "ENC", "BSSID        ", "CH", "RSSI");
    for (i = 0; i < n; i++) {
      WiFi.BSSID(idx[i], bssid);
      Serial.printf("%c %32s %5s %17s %2d %4ld\n",'A'+i,WiFi.SSID(idx[i]), encToString(WiFi.encryptionType(idx[i])), macToString(bssid), WiFi.channel(idx[i]), WiFi.RSSI(idx[i]));
      relayBSSID[i][0]=bssid[0];    //keep MAC addresses
      relayBSSID[i][1]=bssid[1];
      relayBSSID[i][2]=bssid[2];
      relayBSSID[i][3]=bssid[3];
      relayBSSID[i][4]=bssid[4];
      relayBSSID[i][5]=bssid[5];
    }
  }
  Serial.println("Type letter to set relay. Type 0 or 1 to turn relay off or on (eg A0 to turn off first relay).");
}

void loop() {
  int d;
  if(Serial.available()&&(command==0)){ //only read more if all commands processed
    d=Serial.read();
    if((d>='A')&&(d<('A'+n))){
      relay=d;      
      if(!sameMAC(bssid,relayBSSID[relay-'A'])){
        Serial.printf("Connecting to %c, %s\r\n",relay,macToString(relayBSSID[relay-'A']));
        WiFi.begin(ssid,password,relayBSSID[relay-'A']);
      }
    }else if((d>='0')&&(d<='1')){
      command=d;
    }
  }
  WiFi.BSSID(bssid);
  if(relay>='A'){
    if(!sameMAC(nullBSSID,bssid)){                //avoid reconnecting while we're trying to connect
      if(sameMAC(bssid,relayBSSID[relay-'A'])){   //connected to the right Relay
        if(client.connected()){                   //ready to send a command!
          if(command=='0'){
            Serial.println("Turning off.");
            client.print("PIN00=1");
            command=0;  //done
          }
          if(command=='1'){
            Serial.println("Turning on.");
            client.print("PIN00=0");
            command=0;  //done
          }
          delay(100);
          if(client.available()){
            Serial.print("Received from server:[");
            while(client.available()){
              Serial.write(client.read());
            }
          Serial.println("]");
          }
        }else{
          Serial.println("Trying to connect to TCP");
          if (!client.connect(host, port)) {
            Serial.println("TCP Connection failed");
            client.stop();  
          }else{
            Serial.println("TCP Connected");    
          }
        }
      }else{
        Serial.printf("Connecting to %c, %s\r\n",relay,macToString(relayBSSID[relay-'A']));
        WiFi.begin(ssid,password,relayBSSID[relay-'A']);
      }
    }
  }
  if(!sameMAC(lastBSSID,bssid)){
    if(sameMAC(bssid,relayBSSID[relay-'A'])){Serial.printf("Connected to %c, %s\r\n",relay,macToString(bssid));}
    lastBSSID[0]=bssid[0];    //keep MAC addresses
    lastBSSID[1]=bssid[1];
    lastBSSID[2]=bssid[2];
    lastBSSID[3]=bssid[3];
    lastBSSID[4]=bssid[4];
    lastBSSID[5]=bssid[5];
  }
  delay(100);
}

bool sameMAC(uint8_t* a,uint8_t* b){
  if(a[0]!=b[0]){return false;}
  if(a[1]!=b[1]){return false;}
  if(a[2]!=b[2]){return false;}
  if(a[3]!=b[3]){return false;}
  if(a[4]!=b[4]){return false;}
  if(a[5]!=b[5]){return false;}
  return true;
}

const char *macToString(uint8_t mac[6]) {
  static char s[20];
  sprintf(s, "%02X:%02X:%02X:%02X:%02X:%02X", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
  return s;
}

const char *encToString(uint8_t enc) {
  switch (enc) {
    case ENC_TYPE_NONE: return "NONE";
    case ENC_TYPE_TKIP: return "WPA";
    case ENC_TYPE_CCMP: return "WPA2";
    case ENC_TYPE_AUTO: return "AUTO";
  }
  return "UNKN";
}